options(width = 120)
#*********************************************************************************#
#*                                                                                #
#* Purpose: R program to create permanent R .RDS data set                         #
#*          harmonzd_tus_cps_1992_through_2019_with_replicate_wgts_beta           #
#*          with the combined Harmonized TUS CPS data and replicate weights       #
#*                                                                                #
#                                                                                 #
#*********************************************************************************#

##############################################################################################################
# Set working directories
##############################################################################################################

setwd("//westat.com/DFS/NCIDCCPS/DCCPS - Global/Scientific Projects/TUS-CPS/Statistician/ifc/R work/prg/3. Harmonized data")
getwd()

#//*****************************************************************************************
#// Read replicate R files with 1992 to 2019 harmonized data and 1992 to 2019 replicate weights to create
#// one harmonized data analysis file with data and replicate weights

harmonzd_tus_cps_1992_through_2019_beta <- readRDS(file="./harmonzd_tus_cps_1992_through_2019_beta.RDS", refhook = NULL)
harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_19_beta <- readRDS(file="./harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_19_beta.RDS", refhook = NULL)

harmonzd_tus_cps_1992_through_2019_with_replicate_wgts_beta <- merge(harmonzd_tus_cps_1992_through_2019_beta, 
                                                                     harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_19_beta,
                                                                     by=c("SurYear", "SurMonth", "RecordID" ), 
                                                                     all=FALSE, sort = TRUE)

str(harmonzd_tus_cps_1992_through_2019_with_replicate_wgts_beta, list.len=ncol(harmonzd_tus_cps_1992_through_2019_with_replicate_wgts_beta))

saveRDS(harmonzd_tus_cps_1992_through_2019_with_replicate_wgts_beta, file = "./harmonzd_tus_cps_1992_through_2019_with_replicate_wgts_beta.RDS")


